% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openssl_keygen.R
\name{ssh_keygen}
\alias{ssh_keygen}
\title{Create ssh keypairs}
\usage{
ssh_keygen(path = tempfile(), password = TRUE, use_shell = FALSE)
}
\arguments{
\item{path}{A directory in which to create a keypair.  If the path
does not exist it will be created.}

\item{password}{The password for the key.  The default will prompt
interactively (but without echoing the password).  Other valid
options are \code{FALSE} (no password) or a string.}

\item{use_shell}{Try to use \code{ssh-keygen} (the shell utility)
rather than functions in the \code{openssl} package.  This will
be necessary on at least very old versions of OS/X (Yosemite and
older at least) where the keys generated by the \code{openssl}
package cannot be read by the system ssh commands (e.g.,
\code{ssh-add}).}
}
\value{
The \code{path}, invisibly.  This is useful in the case
  where \code{path} is \code{\link{tempfile}()}.
}
\description{
Create openssl key pairs in the manner of \code{ssh-keygen}(1).
In general this should not be used (generate keys yourself with
\code{ssh-keygen} at the command line.  However this is useful for
testing and demonstration so I have included it to make that
easier.  Once a keypair has been generated it can be used with
\code{\link{keypair_openssl}}.
}
\examples{
# Generate a new key in a temporary directory:
path <- cyphr::ssh_keygen(password = FALSE)
dir(path) # will contain id_rsa and id_rsa.pub

# This key can now be used via keypair_openssl:
key <- cyphr::keypair_openssl(path, path)
secret <- cyphr::encrypt_string("hello", key)
cyphr::decrypt_string(secret, key)

# Cleanup
unlink(path, recursive = TRUE)
}
