% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/toolsDaniel.R
\name{constraintL2}
\alias{constraintL2}
\title{Soft L2 constraint on parameters}
\usage{
constraintL2(p, mu, sigma = 1, fixed = NULL)
}
\arguments{
\item{p}{Namec numeric, the parameter value}

\item{mu}{Named numeric, the prior values}

\item{sigma}{Named numeric of length of mu or numeric of length one.}

\item{fixed}{Named numeric with fixed parameter values (contribute to the prior value
but not to gradient and Hessian)}
}
\value{
List of class \code{obj}, i.e. objective value, gradient and Hessian as list.
}
\description{
Soft L2 constraint on parameters
}
\details{
Computes the constraint value
\deqn{\frac{1}{2}\left(\frac{p-\mu}{\sigma}\right)^2}{0.5*(p-mu)^2/sigma^2}
and its derivatives with respect to p.
}
\examples{
p <- c(A = 1, B = 2, C = 3)
mu <- c(A = 0, B = 0)
sigma <- c(A = 0.1, B = 1)
constraintL2(p, mu, sigma)
}
\seealso{
\link{wrss}
}

