% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\name{prdfn}
\alias{prdfn}
\title{Prediction function}
\usage{
prdfn(P2X, parameters = NULL, condition = NULL)
}
\arguments{
\item{P2X}{transformation function as being produced by \link{Xs}.}

\item{parameters}{character vector with parameter names}

\item{condition}{character, the condition name}
}
\value{
Object of class \code{prdfn}, i.e. a function \code{x(..., fixed, deriv, conditions, env)}
which returns a \link{prdlist}. The arguments \code{times} and 
\code{pars} (parameter values) should be passed via the \code{...} argument, in this order.
}
\description{
A prediction function is a function \code{x(..., fixed, deriv, conditions)}.
Prediction functions are generated by \link{Xs}, \link{Xf} or \link{Xd}. For an example
see the last one.
}
\details{
Prediction functions can be "added" by the "+" operator, see \link{sumfn}. Thereby,
predictions for different conditions are merged or overwritten. Prediction functions can
also be concatenated with other functions, e.g. observation functions (\link{obsfn}) or 
parameter transformation functions (\link{parfn}) by the "*" operator, see \link{prodfn}.
}
\examples{
# Define a time grid on which to make a prediction by peace-wise linear function.
# Then define a (generic) prediction function based on thid grid.
times <- 0:5
grid <- data.frame(name = "A", time = times, row.names = paste0("p", times))
x <- Xd(grid)

# Define an observable and an observation function
observables <- eqnvec(Aobs = "s*A")
g <- Y(g = observables, f = NULL, states = "A", parameters = "s")

# Collect parameters and define an overarching parameter transformation
# for two "experimental condtions".
dynpars <- attr(x, "parameters")
obspars <- attr(g, "parameters")
innerpars <- c(dynpars, obspars)

trafo <- structure(innerpars, names = innerpars)
trafo_C1 <- replaceSymbols(innerpars, paste(innerpars, "C1", sep = "_"), trafo)
trafo_C2 <- replaceSymbols(innerpars, paste(innerpars, "C2", sep = "_"), trafo)

p <- NULL
p <- p + P(trafo = trafo_C1, condition = "C1")
p <- p + P(trafo = trafo_C2, condition = "C2")

# Collect outer (overarching) parameters and 
# initialize with random values
outerpars <- attr(p, "parameters")
pars <- structure(runif(length(outerpars), 0, 1), names = outerpars)

# Predict internal/unobserved states
out1 <- (x*p)(times, pars)
plot(out1)

# Predict observed states in addition to unobserved
out2 <- (g*x*p)(times, pars)
plot(out2)
}

