% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction.R
\name{Xd}
\alias{Xd}
\title{Model prediction function from data.frame}
\usage{
Xd(data, condition = NULL)
}
\arguments{
\item{data}{data.frame with columns "name", "time", and row names that 
are taken as parameter names. The data frame can contain a column "value"
to initialize the parameters.}

\item{condition}{either NULL (generic prediction for any condition) or a character, denoting
the condition for which the function makes a prediction.}
}
\value{
Object of class \link{prdfn}, i.e. 
a function \code{x(times pars, deriv = TRUE, conditions = NULL)}, 
see also \link{Xs}. Attributes are "parameters", the parameter names (row names of
the data frame), and possibly "pouter", a named numeric vector which is generated
from \code{data$value}.
}
\description{
Model prediction function from data.frame
}
\examples{
# Generate a data.frame and corresponding prediction function
timesD <- seq(0, 2*pi, 0.5)
mydata <- data.frame(name = "A", time = timesD, value = sin(timesD), 
                     row.names = paste0("par", 1:length(timesD)))
x <- Xd(mydata)

# Evaluate the prediction function at different time points
times <- seq(0, 2*pi, 0.01)
pouter <- structure(mydata$value, names = rownames(mydata))
prediction <- x(times, pouter)
plot(prediction)

}
