% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R, R/dataClass.R
\name{datalist}
\alias{datalist}
\alias{as.datalist}
\alias{as.datalist.data.frame}
\alias{as.datalist.list}
\alias{names<-.datalist}
\alias{is.datalist}
\alias{c.datalist}
\title{Generate a datalist object}
\usage{
datalist(...)

as.datalist(x, ...)

\method{as.datalist}{data.frame}(x, split.by = NULL,
  keep.covariates = NULL, ...)

\method{as.datalist}{list}(x, names = NULL, ...,
  condition.grid = attr(x, "condition.grid"))

\method{names}{datalist}(x) <- value

is.datalist(x)

\method{c}{datalist}(...)
}
\arguments{
\item{...}{data.frame objects to be coerced into a list and additional arguments}

\item{x}{object of class \code{data.frame} or \code{list}. Data frames are required to
provide "name", "time" and "value" as columns. Columns "sigma" and "lloq" can be provided.
If "sigma" and "lloq" are missing, they
are imputed with \code{NA} and \code{-Inf}, respectively.}

\item{split.by}{vector of columns names which yield a unique identifier (conditions). If NULL, all
columns except for the expected standard columns "name", "time", "value", "sigma" and "lloq" will be
selected.}

\item{keep.covariates}{vector of additional column names which should be kept in the condition.grid.}

\item{names}{optional names vector, otherwise names are taken from \code{mylist}}

\item{condition.grid}{Optionally, to manually specify a condition.grid}

\item{value}{The new condition names of the datalist and its condition.grid}
}
\value{
Object of class \code{datalist}.

Object of class \link{datalist}
}
\description{
The datalist object stores time-course data in a list of data.frames.
The names of the list serve as identifiers, e.g. of an experimental condition, etc.
}
\details{
Datalists can be plotted, see \link{plotData} and merged, see \link{sumdatalist}.
They are the basic structure when combining model prediction and data via the \link{normL2}
objective function.

The standard columns of the datalist data frames are "name" (observable name), 
"time" (time points), "value" (data value), "sigma" (uncertainty, can be NA), and
"lloq" (lower limit of quantification, \code{-Inf} by default).

Datalists carry the attribute \code{condition.grid} which contains additional information about different
conditions, such as dosing information for the experiment. It can be conveniently accessed by the \link{covariates}-function.
Reassigning names to a datalist also renames the rows of the \code{condition.grid}.
}
\examples{
## Generate datalist from scratch
mydata1 <- data.frame(name = "A",
                      time = 0:5,
                      value = 0:5,
                      sigma = .1,
                      lloq = -0.5)

mydata2 <- data.frame(name = "A",
                      time = 0:5,
                      value = sin(0:5),
                      sigma = .1)

data <- datalist(C1 = mydata1, C2 = mydata2)
print(data)
plot(data)

## Generate datalist from singla data.frame
times <- seq(0, 2*pi, length.out = 20)
mydata <- data.frame(name = "A", 
                     time = times, 
                     value = c(sin(times), 1.5 * sin(times)), 
                     sigma = .1, 
                     stage = rep(c("upper", "lower"), each = 10),
                     phase = rep(c("first", "second"), each = 20),
                     amplitude = rep(c(1,1.5), each = 20))

data <- as.datalist(mydata, split.by = c("stage", "phase"), keep.covariates = "amplitude")
print(data)
plot(data)

condition.grid <- attr(data, "condition.grid")
print(condition.grid)
}
