% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R, R/parClass.R
\name{parlist}
\alias{parlist}
\alias{as.parlist}
\alias{summary.parlist}
\alias{c.parlist}
\title{Parameter list}
\usage{
parlist(...)

as.parlist(x = NULL)

\method{summary}{parlist}(object, ...)

\method{c}{parlist}(...)
}
\arguments{
\item{...}{Objects to be coerced to parameter list.}

\item{x}{list of lists, as returned by \code{trust}}

\item{object}{a parlist}
}
\description{
The special use of a parameter list is to save
the outcome of multiple optimization runs provided by \link{mstrust},
into one list.

Fitlists carry an fit index which must be held unique on merging
multiple fitlists.
}
\examples{
## Generate a prediction function
regfn <- c(y = "sin(a*time)")

g <- Y(regfn, parameters = "a")
x <- Xt(condition = "C1")

## Generate data
data <- datalist(
  C1 = data.frame(
    name = "y",
    time = 1:5,
    value = sin(1:5) + rnorm(5, 0, .1),
    sigma = .1
  )
)

## Initialize parameters and time 
pars <- c(a = 1)
times <- seq(0, 5, .1)

plot((g*x)(times, pars), data)

## Do many fits from random positions and store them into parlist
out <- as.parlist(lapply(1:50, function(i) {
  trust(normL2(data, g*x), pars + rnorm(length(pars), 0, 1), rinit = 1, rmax = 10)
}))

summary(out)

## Reduce parlist to parframe
parframe <- as.parframe(out)
plotValues(parframe)

## Reduce parframe to best fit
bestfit <- as.parvec(parframe)
plot((g*x)(times, bestfit), data)


}
\seealso{
\link{load.parlist}, \link{plot.parlist}
}
\author{
Wolfgang Mader, \email{Wolfgang.Mader@fdm.uni-freiburg.de}
}
