% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1.input_data.R
\name{dbscan_combination}
\alias{dbscan_combination}
\title{Test eps and minPts combinations for DBSCAN analysis}
\usage{
dbscan_combination(
  refID,
  system = NULL,
  file.location = ".",
  reference.quality = 0.5,
  eps = c(120, 150, 180, 200),
  minPts = c(20, 50, 80, 100)
)
}
\arguments{
\item{refID}{a string or a character vector of chipID (Thermo Fisher) or
the complete file name with the extension (Bio-Rad) of reference sample(s)
to  be analysed.}

\item{system}{character. The name of digital PCR system used to generate
the data. It must be either Thermo Fisher or Bio-Rad. Abbreviations are
also accepted.}

\item{file.location}{character. Full path name to reference and sample
files location. The default corresponds to the working directory,
(\code{\link[base]{getwd}}). Tilde expansion (see
(\code{\link[base]{path.expand}})) is performed.}

\item{reference.quality}{numeric. Between 0 and 1. Quality threshold
to subset the data (just for Thermo Fisher). If different thresholds have
to be applied to various reference samples, a vectror of the same length
of \code{refID} has to be provided.}

\item{eps}{a numeric vector of values to be tested. Maximum distance
between elements within a cluster in a DBSCAN analysis.
See also \code{\link[dbscan]{dbscan}}.}

\item{minPts}{a numeric vector of values to be tested. Number of minimum
elements to assemble a cluster in a DBSCAN analysis.
See also \code{\link[dbscan]{dbscan}}.}
}
\value{
A pdf file containing the scatterplots of DBSCAN analysis performed
with all combinations of eps and minPts.
Each reference generates a different pdf file.
}
\description{
This function tests all combinations of eps and minPts for DBSCAN analysis
of reference samples indicated in refID. The results are represented in
scatterplots exported to a pdf file.
}
\examples{
\donttest{
library(dPCP)

#Find path of sample table and location of reference and input files
sampleTable <- system.file("extdata", "Template_sampleTable.csv",
                     package = "dPCP")

fileLoc <- system.file("extdata", package = "dPCP")

dbscan_combination("dilution20200313_B01_Amplitude.csv",
                   file.location = fileLoc, system = "bio-rad",
                   eps = c(150, 160, 180, 190), minPts = c(80, 100, 120))
}
}
