% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2.clustering_part1.R
\name{reference_dbscan}
\alias{reference_dbscan}
\alias{plot.reference_dbscan}
\title{Find the empty partitions and single target clusters in the reference sample}
\usage{
reference_dbscan(
  reference.subquality,
  sample.table,
  eps = 200,
  minPts = 50,
  save.template = FALSE
)

\method{plot}{reference_dbscan}(x, ..., reference = "all")
}
\arguments{
\item{reference.subquality}{an object of class \code{read_reference},
inherited from \code{\link{read_reference}}.}

\item{sample.table}{object of class \code{sample_table}, inherited from
\code{\link{read_sampleTable}}.}

\item{eps}{numeric. Input parameters for the DBSCAN algorithm. If
they match the paramters of \code{\link{reference_dbscan}} template file,
the data are retrived from the template.}

\item{minPts}{numeric. Input parameters for the DBSCAN algorithm. If
they match the paramters of \code{\link{reference_dbscan}} template file,
the data are retrived from the template.}

\item{save.template}{logical. If TRUE a template of DBSCAN analysis of
reference samples is saved. When \code{system} is Thermo Fisher,
\code{save.template} can be also a character vector indicating the chipID.}

\item{x}{an object of class \code{reference_dbscan}}

\item{...}{Arguments to be passed to methods}

\item{reference}{'all' to show all reference samples, or a character vector
with chip ID (Thermo Fisher) or the file name (Bio-rad) of reference
samples to be showed.}
}
\value{
An object of class \code{reference_dbscan} containing a sublist for
  each reference. Each sublist has the following components:
  \item{quality}{quality threshold used in \code{\link{read_reference}}.}
  \item{data}{a matrix with the fluorescence intensities and quality
  values.}
  \item{dbscan}{an object of class \code{dbscan_fast}, inherited from
  \code{\link[dbscan]{dbscan}}.}
}
\description{
This function computes a DBSCAN analysis to identify single target clusters
in the reference samples listed in the sample table.
If a \code{\link{reference_dbscan}} template file with the same input
paramters (reference ID, eps, minPts) is available, data are retrived
from the template file.
}
\examples{
\donttest{
library(dPCP)

#Find path of sample table and location of reference and input files
sampleTable <- system.file("extdata", "Template_sampleTable.csv",
                     package = "dPCP")

fileLoc <- system.file("extdata",package = "dPCP")

#Read sample table file
sample.table <- read_sampleTable(sampleTable, system = "bio-rad",
                                 file.location = fileLoc)

#Read reference files
ref <- read_reference(sample.table, system = "bio-rad",
                      file.location = fileLoc)

#Read samples files
samp <- read_sample(sample.table, system = "bio-rad",
                    file.location = fileLoc)

#Reference DBSCAN clustering
dbref <- reference_dbscan(ref, sample.table, save.template = FALSE)

plot(dbref, reference = "all")
}
}
