% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join_mpa_data.R
\name{join_mpa_data}
\alias{join_mpa_data}
\title{Detect fishing vessel presence within Marine Protected Areas polygons in Mexico}
\usage{
join_mpa_data(x, all_mpas = all_mpas)
}
\arguments{
\item{x}{A data.frame with VMS data that must contain columns longitude and latitude}

\item{all_mpas}{A shape file that contains all MPA polygons in Mexico you can upload this using \code{data("all_mpas")}}
}
\value{
A data.frame
}
\description{
The function spatially joins the Vessels Monitoring System, VMS, points with the Marine Protected Area, MPAs, polygons in Mexico.
}
\details{
It adds three columns \code{zone}, \code{mpa_decree}, \code{state}, \code{municipality}, \code{region}, which are data from the
MPAs polygon. \code{zone} contains the name of the MPA (in Spanish) and when the vessel is outside an MPA polygon is dubbed as \verb{open area},
\code{mpa_decree} contains the type of MPA (such as National Park, etc.),
\code{state} contains the Mexican state with jurisdiction on the MPA, \code{municipality} contains the Mexican municipality with jurisdiction over the MPA,
and \code{region} contains the overall location of the MPA (in Spanish)
}
\examples{


# Use sample_dataset
data("sample_dataset")
data("all_mpas")
vms_cleaned <- vms_clean(sample_dataset)
vms_mpas <- join_mpa_data(vms_cleaned, all_mpas)


# Plotting data
# Points NOT inside MPA are removed to reduce data size
vms_mpas_sub <- vms_mpas  |>
  dplyr::filter(zone != "open area")

vms_mpas_sf <- sf::st_as_sf(vms_mpas_sub, coords = c("longitude", "latitude"), crs = 4326)

# Loading Mexico shapefile
data("mx_shape")

# Map
library(ggplot2)
ggplot(mx_shape, col = "gray90") +
  geom_sf(data = all_mpas, fill = "gray60") +
  geom_sf(data = vms_mpas_sf, aes(col = zone)) +
  theme_void() +
  theme(legend.position = "")
}
