% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dagitty.r
\name{edges}
\alias{edges}
\title{Graph Edges}
\usage{
edges(x)
}
\arguments{
\item{x}{the input graph, of any type.}
}
\value{
a data frame with the following variables:
\itemize{
 \item{v}{ name of the start node.}
 \item{w}{ name of the end node. For symmetric edges (bidirected and undirected), the
 order of start and end node is arbitrary.}
 \item{e}{ type of edge. Can be one of \code{"->"}, \code{"<->"} and \code{"--"}.}
 \item{x}{ X coordinate for a control point. If this is not \code{NA}, then the edge
 is drawn as an \code{\link{xspline}} through the start point, this control point, 
 and the end point. This is especially important for cases where there is more than
 one edge between two variables (for instance, both a directed and a bidirected edge).}
 \item{y}{ Y coordinate for a control point.}
}
}
\description{
Extracts edge information from the input graph.
}
\examples{
## Which kinds of edges are used in the Shrier example?
levels( edges( getExample("Shrier") )$e )
}
