% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/send_to_dai.R
\name{dai_status}
\alias{dai_status}
\title{Check job status}
\usage{
dai_status(response, loc = "eu", token = dai_token(), verbose = FALSE)
}
\arguments{
\item{response}{A HTTP response object generated by \code{dai_async()} or
\code{dai_tab_async()}}

\item{loc}{A two-letter region code; "eu" or "us"}

\item{token}{An authentication token generated by \code{dai_auth()} or
another auth function}

\item{verbose}{boolean; Whether to output the full response}
}
\value{
If verbose was set to \code{TRUE}, a HTTP response object.
If verbose was set to \code{FALSE}, a string summarizing the status.
}
\description{
Queries the Google Cloud Services (GCS) Document AI API
about the status of a previously submitted asynchronous job.
}
\examples{
\dontrun{
# Short status message:
response <- dai_async(myfiles)
dai_status(response)

# Full status details:
response <- dai_async(myfiles)
status <- dai_status(response, verbose = TRUE)
}
}
