% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cla_mlp.R
\name{cla_mlp}
\alias{cla_mlp}
\title{MLP for classification}
\usage{
cla_mlp(attribute, slevels, size = NULL, decay = 0.1, maxit = 1000)
}
\arguments{
\item{attribute}{attribute target to model building}

\item{slevels}{possible values for the target classification}

\item{size}{number of nodes that will be used in the hidden layer}

\item{decay}{how quickly it decreases in gradient descent}

\item{maxit}{maximum iterations}
}
\value{
returns a classification object
}
\description{
Creates a classification object that
uses the Multi-Layer Perceptron (MLP) method.
It wraps the nnet library.
}
\examples{
data(iris)
slevels <- levels(iris$Species)
model <- cla_mlp("Species", slevels, size=3, decay=0.03)

# preparing dataset for random sampling
sr <- sample_random()
sr <- train_test(sr, iris)
train <- sr$train
test <- sr$test

model <- fit(model, train)

prediction <- predict(model, test)
predictand <- adjust_class_label(test[,"Species"])
test_eval <- evaluate(model, predictand, prediction)
test_eval$metrics
}
