% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psa.R
\name{plot.psa}
\alias{plot.psa}
\title{Plot the psa object}
\usage{
\method{plot}{psa}(
  x,
  center = TRUE,
  ellipse = TRUE,
  alpha = 0.2,
  txtsize = 12,
  col = c("full", "bw"),
  n_x_ticks = 6,
  n_y_ticks = 6,
  xbreaks = NULL,
  ybreaks = NULL,
  xlim = NULL,
  ylim = NULL,
  ...
)
}
\arguments{
\item{x}{the psa object}

\item{center}{plot the mean cost and effectiveness for each strategy. defaults to TRUE}

\item{ellipse}{plot an ellipse around each strategy. defaults to TRUE}

\item{alpha}{opacity of the scatterplot points.
0 is completely transparent, 1 is completely opaque}

\item{txtsize}{base text size}

\item{col}{either none, full color, or black and white}

\item{n_x_ticks}{number of axis ticks}

\item{n_y_ticks}{number of axis ticks}

\item{xbreaks}{vector of axis breaks.
will override \code{n_x_ticks} and/or \code{n_y_ticks} if provided.}

\item{ybreaks}{vector of axis breaks.
will override \code{n_x_ticks} and/or \code{n_y_ticks} if provided.}

\item{xlim}{vector of axis limits, or NULL, which sets limits automatically}

\item{ylim}{vector of axis limits, or NULL, which sets limits automatically}

\item{...}{further arguments to plot.
This is not used by \code{dampack} but required for generic consistency.}
}
\value{
A \code{ggplot2} plot of the PSA, showing the distribution of each PSA sample and strategy
on the cost-effectiveness plane.
}
\description{
Plot the psa object
}
