% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsa_twoway.R
\name{create_dsa_twoway}
\alias{create_dsa_twoway}
\title{Create one-way deterministic sensitivity analysis object}
\usage{
create_dsa_twoway(
  parameters,
  effectiveness = NULL,
  strategies,
  cost = NULL,
  currency = "$",
  other_outcome = NULL
)
}
\arguments{
\item{parameters}{parameter values associated with effectiveness and outcomes.
The table must have two columns, one for each parameter.
The parameter names must be the column names.

\tabular{ll}{
param1 name     \tab param2 name \cr
param1 val1     \tab param2 val1 \cr
param1 val2     \tab param2 val2 \cr
...            \tab ... \cr
}}

\item{effectiveness}{data frames containing data for costs,
effectiveness or another outcome (user-defined), respectively.
Each simulation should be a row of the data frame, and each strategy should be a column.
Naming the columns of the data frames is not necessary, as they will be renamed with
the \code{strategies} vector.}

\item{strategies}{vector with the names of the strategies. Due to requirements in
certain uses of this vector, this function uses \code{\link{make.names}} to modify
strategy names as necessary. It is strongly suggested that you follow the rules
in the \code{\link{make.names}} help page, to avoid unexpected errors.}

\item{cost}{data frames containing data for costs,
effectiveness or another outcome (user-defined), respectively.
Each simulation should be a row of the data frame, and each strategy should be a column.
Naming the columns of the data frames is not necessary, as they will be renamed with
the \code{strategies} vector.}

\item{currency}{symbol for the currency being used (ex. "$", "£")}

\item{other_outcome}{data frames containing data for costs,
effectiveness or another outcome (user-defined), respectively.
Each simulation should be a row of the data frame, and each strategy should be a column.
Naming the columns of the data frames is not necessary, as they will be renamed with
the \code{strategies} vector.}
}
\value{
a class \code{dsa_twoway} object that can be passed to the \code{\link{twsa}} function
to visualize the two-way sensitivity analysis contained in the object.
}
\description{
The object returned by this function can be passed to
\code{\link{owsa}} to do a one-way sensitivity analysis on each
parameter of interest.
}
