% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load-dam.R
\name{load_dam}
\alias{load_dam}
\alias{load_dam2}
\title{Load DAMS data from one or several continuous text files}
\usage{
load_dam(metadata, FUN = NULL, ...)
}
\arguments{
\item{metadata}{\link[data.table:data.table]{data.table::data.table} used to load data (see detail)}

\item{FUN}{function (optional) to transform the data from each animal
immediately after is has been loaded.}

\item{...}{extra arguments to be passed to \code{FUN}}
}
\value{
A \link[behavr:behavr]{behavr::behavr} table.
In addition to the metadata, it contains the data, whith the columns:
\itemize{
\item \code{id} -- autogenerated unique identifier, one per animal
\item \code{t} -- time
\item \code{activity} -- number of beam crosses
}
}
\description{
Uses "linked metadata" to load data from either single beam (DAM2) or multibeam (DAM5) arrays.
}
\details{
The linked metadata should be generated using \link{link_dam_metadata}.
}
\examples{
# This is where our toy data lives
root_dir <- damr_example_dir()

# Metadata already made for us.
# It defines condition and genotype of each animal
data(single_file_metadata)
print(single_file_metadata)
# Linking:
metadata <- link_dam_metadata(single_file_metadata, root_dir)

# We find and load the matching data
dt <- load_dam(metadata)
print(dt)
# An example of the use of FUN,
# we load only the first few reads by run `head()` on each animal,
# on the fly (no pun intended)
dt <- load_dam(metadata, FUN = head)
print(dt)
}
\references{
\itemize{
\item \href{https://rethomics.github.io/damr.html}{damr tutorial} -- how to use this function in practice
}
}
\seealso{
\itemize{
\item \link[behavr:behavr]{behavr::behavr} --  the class of the resulting object
\item \link{read_dam_file} --  to load data from a single file (without metadata)
}
}
