% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/muteTweets.R
\name{muteTweeters}
\alias{muteTweeters}
\title{Mute Twitter Users with Excessive Hashtag Use}
\usage{
muteTweeters(term = "#rstats", N = 1000, ncrit = 10)
}
\arguments{
\item{term}{A character variable to search for, defaults to \sQuote{#rstats}}

\item{N}{An number of tweets to fetch, defaults to 1000}

\item{ncrit}{A number of hashtags after which use is deemed excessive, defaults to 10}
}
\value{
\code{NULL}, invisibly, but the function is invoked for the side effect
of calling \code{post_mute}.
}
\description{
Mutes Twitter accounts using for than 'ncrit' hashtags among 'N' tweets in
search of along with of 'term'.
}
\details{
This is a modified version of the code in this wonderful tweet by Colin
Gillespie at \url{https://twitter.com/csgillespie/status/1298621645767290881}.
It requires the \code{rtweet} and \code{data.table} packages.
}
\examples{
\dontrun{
## mute users with more than 10 hashtags among
## the 1000 most recent #rstats tweets
muteTweeters("#rstats", 1000, 10)
}
}
\author{
Dirk Eddelbuettel
}
