% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrete_gaussian.R
\name{ddnorm}
\alias{ddnorm}
\alias{rdnorm}
\title{The Discrete Gaussian Distribution}
\usage{
ddnorm(x, mu = 0, sigma = 1, log = FALSE)

rdnorm(n, mu = 0, sigma = 1)
}
\arguments{
\item{x}{vector of quantiles.}

\item{mu}{location parameter.}

\item{sigma}{scale parameter.}

\item{log}{logical; if \code{TRUE}, probabilities are given as log(p).}

\item{n}{number of random deviates.}
}
\value{
\itemize{
\item ddnorm() returns a numeric vector representing the probability mass function of the
discrete Gaussian distribution.
\item rdnorm() returns a numeric vector of random samples from the discrete Gaussian distribution.
}
}
\description{
The probability mass function and random number generator for the
discrete Gaussian distribution with mean \code{mu} and scale parameter \code{sigma}.
}
\details{
Probability mass function
\deqn{
P[X = x] = \dfrac{e^{-(x - \mu)^2/2\sigma^2}}{\sum_{y \in \mathbb{Z}} e^{-(x-\mu)^2/2\sigma^2}}.
}
}
\examples{
# mass function
ddnorm(0)

# mass function is also vectorized
ddnorm(0:10, mu = 0, sigma = 5)

# generate random samples
rdnorm(10)

}
\references{
Canonne, C. L., Kamath, G., & Steinke, T. (2020). The Discrete Gaussian for Differential Privacy.
\emph{arXiv}. \doi{https://doi.org/10.48550/ARXIV.2004.00010}
}
