% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/darch.Learn.R
\docType{methods}
\name{fineTuneDArch,DArch-method}
\alias{fineTuneDArch,DArch-method}
\title{Fine tuning function for the deep architecture}
\usage{
\S4method{fineTuneDArch}{DArch}(darch, dataSet, dataSetValid = NULL,
  numEpochs = 1, bootstrap = T, isBin = FALSE, isClass = TRUE,
  stopErr = -Inf, stopClassErr = 101, stopValidErr = -Inf,
  stopValidClassErr = 101, ...)
}
\arguments{
\item{darch}{A instance of the class \code{\linkS4class{DArch}}.}

\item{dataSet}{\code{\linkS4class{DataSet}} containing training and
optionally validation and test data.}

\item{dataSetValid}{\code{\linkS4class{DataSet}} to be used for validation.}

\item{numEpochs}{The number of training iterations}

\item{bootstrap}{Whether to use bootstrapping to create validation data.}

\item{isBin}{Indicates whether the output data must be interpreted as boolean
value. Default is \code{FALSE}. If it is true, every value over 0.5 is
interpreted as 1 and under as 0.}

\item{isClass}{Indicates whether the training is for a classification net.
When \code{TRUE} then statistics for classification will be determind.
Default is \code{TRUE}}

\item{stopErr}{Stop criteria for the error on the train data. Default is
\code{-Inf}}

\item{stopClassErr}{Stop criteria for the classification error on the train
data. Default is \code{101}}

\item{stopValidErr}{Stop criteria for the error on the validation data.
Default is \code{-Inf}.}

\item{stopValidClassErr}{Stop criteria for the classification error on the
validation data. Default is \code{101} .}

\item{...}{Additional parameters for the training function}
}
\description{
Fine tuning function for the deep architecture
}
\seealso{
\link{fineTuneDArch}
}

