% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/darch.Learn.R
\name{fineTuneDArch}
\alias{fineTuneDArch}
\title{Fine tuning function for the deep architecture}
\usage{
fineTuneDArch(darch, dataSet, dataSetValid = NULL, numEpochs = 1,
  isClass = TRUE, stopErr = -Inf, stopClassErr = 101,
  stopValidErr = -Inf, stopValidClassErr = 101, shuffleTrainData = T,
  debugMode = F, ...)
}
\arguments{
\item{darch}{A instance of the class \code{\linkS4class{DArch}}.}

\item{dataSet}{\code{\linkS4class{DataSet}} containing training and 
optionally validation and test data.}

\item{dataSetValid}{\code{\linkS4class{DataSet}} to be used for validation.}

\item{numEpochs}{The number of training iterations}

\item{isClass}{Indicates whether the training is for a classification net. 
When \code{TRUE} then statistics for classification will be determind. 
Default is \code{TRUE}}

\item{stopErr}{Stop criteria for the error on the train data. Default is 
\code{-Inf}}

\item{stopClassErr}{Stop criteria for the classification error on the train 
data. Default is \code{101}}

\item{stopValidErr}{Stop criteria for the error on the validation data. 
Default is \code{-Inf}.}

\item{stopValidClassErr}{Stop criteria for the classification error on the 
validation data. Default is \code{101}.}

\item{shuffleTrainData}{Whether to shuffle train data before each epoch.}

\item{debugMode}{Whether to enable debug mode, internal parameter.}

\item{...}{Additional parameters for the training function}

\item{bootstrap}{Whether to use bootstrapping to create validation data.}
}
\value{
Trained \code{\linkS4class{DArch}} instance.
}
\description{
The fine tuning function for deep architectures. This function use the 
function saved in the attribute \code{fineTuneFunction} to train the deep 
architecture.
}
\details{
The function trains the given network \code{darch} with the function
  saved in the attribute \code{fineTuneFunction} of the 
  \code{\linkS4class{DArch}}-Object. The data and classes for validation and
  testing are optional. If they are provided the network will be executed
  with this datasets and statistics will be calculated. This statistics are
  saved in the \code{stats} attribute (see \code{\linkS4class{Net}}). Also it
  is possible to set stop criteria for the training on the error 
  (\code{stopErr}, \code{stopValidErr}) or the correct classifications 
  (\code{stopClassErr}, \code{stopValidClassErr}) of the training or 
  validation dataset.
}
\seealso{
\code{\linkS4class{DArch}}, \code{\linkS4class{Net}}, 
  \code{\link{backpropagation}}, \code{\link{rpropagation}}, 
  \code{\link{minimizeAutoencoder}}, \code{\link{minimizeClassifier}}
}
\keyword{internal}

