% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbmUnitFunctions.R
\name{sigmoidUnitRbm}
\alias{sigmoidUnitRbm}
\title{Calculates the RBM neuron output with the sigmoid function}
\usage{
sigmoidUnitRbm(rbm, data, biases, weights, runParams,
  matMult = getParameter(".matMult", ...), ...)
}
\arguments{
\item{rbm}{An instance of the class \code{\linkS4class{RBM}}.}

\item{data}{A matrix with the data for the calculations.}

\item{biases}{The biases for the calculations.}

\item{weights}{The weight matrix for the calculations.}

\item{runParams}{Parameters which indicates the status of the training.}

\item{matMult}{Matrix multiplication function.}

\item{...}{Additional parameters, not used.}
}
\value{
The real value and binary activations for the units
}
\description{
Calculates the RBM neuron output with the sigmoid function from input saved
in \code{data}.
}
\details{
The return value is a list with the output of the sigmoid function 
as first entry and binary representation calculated through a comparison of 
the output with random numbers. The random numbers a generated with the 
function \code{\link{runif}}.
}
\seealso{
Other RBM unit functions: \code{\link{linearUnitRbm}},
  \code{\link{tanhUnitRbm}}
}
\keyword{internal}

