% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.dist.heatmap.r
\name{gl.dist.heatmap}
\alias{gl.dist.heatmap}
\title{Represent a distance matrix as a heatmap}
\usage{
gl.dist.heatmap(dst, ncolors = 5, labels = TRUE, values = TRUE,
  rank = FALSE, v = 2)
}
\arguments{
\item{dst}{-- name of the distance matrix [required]}

\item{ncolors}{-- number of colors to display [default 5]}

\item{labels}{-- if TRUE, and the number of rows is <= 20, labels are added to the heatmap [default = TRUE]}

\item{values}{-- if TRUE, and the number of rows is <= 20, distances are added to the body of the heatmap [default = TRUE]}

\item{rank}{-- if TRUE, then the distance matrix will be reordered to group like with like, otherwise order will be displayed as given [default FALSE]}

\item{v}{-- verbosity: 0, silent or fatal errors; 1, begin and end; 2, progress log ; 3, progress and results summary; 5, full report [default 2]}
}
\description{
The script plots a heat map to represent the distances in the distance or dissimilarity matrix
}
\examples{
   gl <- testset.gl[1:10,]
   d <- dist(as.matrix((gl)))
   gl.dist.heatmap(d)
   gl.dist.heatmap(d, ncolors=10, rank=TRUE)
}
\author{
Arthur Georges (Post to \url{https://groups.google.com/d/forum/dartr})
}
