% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.filter.pa.r
\name{gl.filter.pa}
\alias{gl.filter.pa}
\title{Filters loci that contain private (and fixed alleles) between two populations}
\usage{
gl.filter.pa(x, pop1, pop2, invers = FALSE, verbose = NULL)
}
\arguments{
\item{x}{Name of the genlight object containing the SNP data [required].}

\item{pop1}{Name of the first parental population (in quotes) [required].}

\item{pop2}{Name of the second parental population (in quotes) [required].}

\item{invers}{Switch to filter for all loci that have no private alleles and
are not fixed [FALSE].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
[default 2, unless specified using gl.set.verbosity].}
}
\value{
The reduced genlight dataset, containing now only fixed and private
alleles.
}
\description{
This script is meant to be used prior to \code{gl.nhybrids} to maximise the
information content of the SNPs used to identify hybrids (currently
 newhybrids does allow only 200 SNPs). The idea is to use first all loci that
  have fixed alleles between the potential source populations and then 'fill
   up' to 200 loci using loci that have private alleles between those. The
   functions filters for those loci (if invers is set to TRUE, the opposite
   is returned (all loci that are not fixed and have no private alleles - not
    sure why yet, but maybe useful.)
}
\examples{
result <- gl.filter.pa(testset.gl, pop1=pop(testset.gl)[1], pop2=pop(testset.gl)[2],verbose=3)
}
\author{
Authors: Bernd Gruber & Ella Kelly (University of Melbourne);
Custodian: Luis Mijangos -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
