% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.filter.reproducibility.r
\name{gl.filter.reproducibility}
\alias{gl.filter.reproducibility}
\title{Filters loci in a genlight \{adegenet\} object based on average
 repeatability of alleles at a locus}
\usage{
gl.filter.reproducibility(
  x,
  threshold = 0.99,
  plot.out = TRUE,
  plot_theme = theme_dartR(),
  plot_colors = two_colors,
  save2tmp = FALSE,
  verbose = NULL
)
}
\arguments{
\item{x}{Name of the genlight object containing the SNP data [required].}

\item{threshold}{Threshold value below which loci will be removed
[default 0.99].}

\item{plot.out}{If TRUE, displays a plots of the distribution of
reproducibility values before and after filtering [default TRUE].}

\item{plot_theme}{Theme for the plot [default theme_dartR()].}

\item{plot_colors}{List of two color names for the borders and fill of the
plots [default two_colors].}

\item{save2tmp}{If TRUE, saves any ggplots and listings to the session
temporary directory (tempdir) [default FALSE].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log ; 3, progress and results summary; 5, full report
[default 2, unless specified using gl.set.verbosity].}
}
\value{
Returns a genlight object retaining loci with repeatability (Repavg
or Reproducibility) greater than the specified threshold.
}
\description{
SNP datasets generated by DArT have an index, RepAvg, generated by
reproducing the data independently for 30% of loci. RepAvg is the proportion
of alleles that give a repeatable result, averaged over both alleles for each
locus.

SilicoDArT datasets generated by DArT have a similar index, Reproducibility.
For these fragment presence/absence data, repeatability is the percentage of
scores that are repeated in the technical replicate dataset.
}
\examples{
# SNP data
  gl.report.reproducibility(testset.gl)
  result <- gl.filter.reproducibility(testset.gl, threshold=0.99, verbose=3)
# Tag P/A data
  gl.report.reproducibility(testset.gs)
  result <- gl.filter.reproducibility(testset.gs, threshold=0.99)
}
\seealso{
\code{\link{gl.report.reproducibility}}

Other filters and filter reports: 
\code{\link{gl.filter.allna}()},
\code{\link{gl.filter.monomorphs}()},
\code{\link{gl.filter.rdepth}()},
\code{\link{gl.filter.secondaries}()},
\code{\link{gl.report.callrate}()},
\code{\link{gl.report.hamming}()},
\code{\link{gl.report.locmetric}()},
\code{\link{gl.report.monomorphs}()},
\code{\link{gl.report.rdepth}()},
\code{\link{gl.report.reproducibility}()},
\code{\link{gl.report.taglength}()}
}
\author{
Custodian: Arthur Georges -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
\concept{filters and filter reports}
