% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.R
\docType{methods}
\name{map}
\alias{flatmap}
\alias{flatmap,ANY,formula-method}
\alias{map}
\alias{map,ANY,formula-method}
\alias{map,MList,function-method}
\alias{map,atomic,function-method}
\alias{map,formula,function-method}
\alias{map,list,function-method}
\alias{map,list,numericORcharacterORlogical-method}
\alias{sac}
\alias{sac,ANY,formula-method}
\alias{sac,data.frame,function-method}
\alias{vmap}
\title{An implementation of map}
\usage{
map(x, f, ...)

\S4method{map}{ANY,formula}(x, f, ...)

\S4method{map}{atomic,`function`}(x, f, ...)

\S4method{map}{list,`function`}(x, f, p = function(x) TRUE, ...)

\S4method{map}{list,numericORcharacterORlogical}(x, f, ...)

\S4method{map}{MList,`function`}(x, f, ..., simplify = FALSE)

\S4method{map}{formula,`function`}(x, f, ...)

flatmap(x, f, ..., flatten = unlist)

\S4method{flatmap}{ANY,formula}(x, f, ..., flatten = unlist)

sac(x, f, by, ..., combine = bindRows)

\S4method{sac}{data.frame,`function`}(x, f, by, ..., combine = bindRows)

\S4method{sac}{ANY,formula}(x, f, by, ..., combine = bindRows)

vmap(x, f, ..., .mc = min(length(x), detectCores()), .bar = "bar")
}
\arguments{
\item{x}{(\link{vector} | \link{data.frame} | formula) if x inherits from
data.frame, a data.frame is returned. Use \link{as.list} if this is not
what you want. When x is a formula it is interpreted to trigger a
multivariate map.}

\item{f}{(\link{function} | \link{formula} | character | logical | numeric)
something which can be interpreted as a function. formula objects are
coerced to a function. atomics are used for subsetting in each element of
x. See the examples.}

\item{...}{further arguments passed to the apply function.}

\item{p}{(function | formula) a predicate function indicating which columns
in a data.frame to use in map. This is a filter for the map operation, the
full data.frame is returned.}

\item{simplify}{see SIMPLIFY in \link{mapply}}

\item{flatten}{(function | formula) a function used to flatten the results.}

\item{by}{(e.g. character) argument is passed to \link{extract} to select
columns.}

\item{combine}{(function | formula) a function which knows how to combine the
list of results. \link{bindRows} is the default.}

\item{.mc}{(integer) the number of cores. Passed down to \link{mclapply} or
\link{mcmapply}.}

\item{.bar}{(character) see \link{verboseApply}.}
}
\description{
An implementation of map and flatmap. They support the use of formulas as
syntactic sugar for anonymous functions.
}
\details{
\code{map} will dispatch to \link{lapply}. When \code{x} is a
formula this is interpreted as a multivariate map; this is implemented
using \code{mapply}.  When \code{x} is a data.frame \code{map} will iterate
over columns, however the return value is a \code{data.frame}. \code{p} can
be used to map over a subset of \code{x}.

\code{flatmap} will dispatch to \code{map}. The result is then wrapped by
\code{flatten} which is \link{unlist} by default.

\code{sac} is a naive implementation of split-apply-combine and implemented
using \code{flatmap}.

\code{vmap} is a 'verbose' version of \code{map} and provides a progress bar
and a link to parallel map (\link{mclapply}).

\code{map}, \code{flatmap}, and \code{sac} can be extended; they are S4
generic functions. You don't and should not implement a new method for
formulas. This method will coerce a formula into a function and pass it down
to your map(newtype, function) method.
}
\examples{
# Sugar for anonymous functions
map(data.frame(y = 1:10, z = 2), x ~ x + 1)
map(data.frame(y = 1:10, z = 2), x ~ x + 1, is.numeric)
map(data.frame(y = 1:10, z = 2), x ~ x + 1, x ~ all(x == 2))
sac(data.frame(y = 1:10, z = 1:2), df ~ data.frame(my = mean(df$y)), "z")

# Trigger a multivariate map with a formula
map(1:2 ~ 3:4, f(x, y) ~ x + y)
map(1:2 ~ 3:4, f(x, y) ~ x + y, simplify = TRUE)
map(1:2 ~ 3:4, f(x, y, z) ~ x + y + z, z = 1)

# Extracting values from lists
map(list(1:2, 3:4), 2)
map(list(1:3, 2:5), 2:3)
map(list(1:3, 2:5), c(TRUE, FALSE, TRUE))

# Some type checking along the way
map(as.numeric(1:2), numeric : x ~ x)
map(1:2, integer(1) : x ~ x)
map(1:2, numeric(1) : x ~ x + 0.5)
}

