% Generated by roxygen2 (4.0.2): do not edit by hand
\name{getNWISDataAvailability}
\alias{getNWISDataAvailability}
\title{USGS data availability}
\usage{
getNWISDataAvailability(siteNumber, type = c("uv", "dv", "qw"))
}
\arguments{
\item{siteNumber}{string USGS site number.}

\item{type}{vector string. Options are "uv", "dv", "qw"}
}
\value{
retval dataframe with all information found in the expanded site file
}
\description{
Imports a table of available parameters, period of record, and count.
}
\examples{
# These examples require an internet connection to run
availableData <- getNWISDataAvailability('05114000')
# To find just unit value ('instantaneous') data:
uvData <- getNWISDataAvailability('05114000',type="uv")
uvDataMulti <- getNWISDataAvailability(c('05114000','09423350'),type="uv")
}
\keyword{USGS}
\keyword{data}
\keyword{import}
\keyword{service}
\keyword{web}

