% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_session_zip.R
\name{download_session_zip}
\alias{download_session_zip}
\title{Download Zip Archive From Databrary Session.}
\usage{
download_session_zip(
  vol_id = 31,
  session_id = 9803,
  out_dir = tempdir(),
  file_name = "test.zip",
  vb = options::opt("vb"),
  rq = NULL
)
}
\arguments{
\item{vol_id}{Volume number.}

\item{session_id}{Slot/session number.}

\item{out_dir}{Directory to save output file.}

\item{file_name}{Name for downloaded file, default is 'test.zip'.}

\item{vb}{Show verbose messages. (Defaults to \code{FALSE}, overwritable using option 'databraryr.vb' or environment variable 'R_DATABRARYR_VB')}

\item{rq}{An \code{httr2} request object. Default is NULL.}
}
\value{
Full filename of the downloaded file.
}
\description{
Download Zip Archive From Databrary Session.
}
\examples{
\donttest{
\dontrun{
download_session_zip() # Downloads Zip Archive from volume 31, session 9803
}
}

}
