% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R
\name{add_arcs_name}
\alias{add_arcs_name}
\title{Add arcs}
\usage{
add_arcs_name(p, origin, destination, ...)
}
\arguments{
\item{p}{a datamaps object.}

\item{origin, destination}{edges.}

\item{...}{any other arguments to use as options.}
}
\description{
Add arcs by name of country of state.
}
\examples{
data <- data.frame(origin = c("USA", "FRA", "CHN", "RUS", "COG", "DZA"),
    target = c("FRA", "RUS", "BEL", "CAF", "VEN", "SWZ"),
    greatArc = rep(c(TRUE, FALSE), 3),
    arcSharpness = 2)

data \%>\%
    datamaps() \%>\%
    add_arcs_name(origin, target, greatArc, arcSharpness)

# US states
states <- data.frame(origin = c("AR", "NY", "CA", "IL", "CO", "MT",
                                "TX", "WA", "TN", "MT"),
    target = c("OR", "SD", "WI", "TX", "LA", "AZ", "FL", "MI", "HI",
               "OK"),
    strokeWidth = runif(10, 1, 9),
    strokeColor = colorRampPalette(c("red", "blue"))(10))

states \%>\%
    datamaps(scope = "USA", default = "lightgray") \%>\%
    add_arcs_name(origin, target, strokeWidth, strokeColor)

}
