% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edit-data.R
\name{edit-data}
\alias{edit-data}
\alias{edit_data_ui}
\alias{edit_data_server}
\title{Shiny module to interactively edit a \code{data.frame}}
\usage{
edit_data_ui(id)

edit_data_server(
  id,
  data_r = reactive(NULL),
  add = TRUE,
  update = TRUE,
  delete = TRUE,
  download_csv = TRUE,
  download_excel = TRUE,
  file_name_export = "data",
  var_edit = NULL,
  var_mandatory = NULL,
  return_class = c("data.frame", "data.table", "tbl_df", "raw")
)
}
\arguments{
\item{id}{Module ID}

\item{data_r}{data_r \code{reactive} function containing a \code{data.frame} to use in the module.}

\item{add}{\code{boolean}, if \code{TRUE}, allows you to add a row in the table via a button at the top right}

\item{update}{\code{boolean}, if \code{TRUE}, allows you to modify a row of the table via a button located in the table on the row you want to edit}

\item{delete}{\code{boolean}, if \code{TRUE}, allows a row to be deleted from the table via a button in the table}

\item{download_csv}{if \code{TRUE}, allows to export the table in csv format via a download button}

\item{download_excel}{if \code{TRUE}, allows to export the table in excel format via a download button}

\item{file_name_export}{\code{character} that allows you to choose the export name of the downloaded file}

\item{var_edit}{vector of \code{character} which allows to choose the names of the editable columns}

\item{var_mandatory}{vector of \code{character} which allows to choose obligatory fields to fill}

\item{return_class}{Class of returned data: \code{data.frame}, \code{data.table}, \code{tbl_df} (tibble) or \code{raw}.}
}
\value{
the edited \code{data.frame} in reactable format with the user modifications
}
\description{
The module generates different options to edit a \code{data.frame}: adding, deleting and modifying rows, exporting data (csv and excel), choosing editable columns, choosing mandatory columns.
This module returns the edited table with the user modifications.
}
\examples{
library(shiny)
library(datamods)
library(bslib)

ui <- fluidPage(
  theme = bs_theme(
    version = 5
  ),
  tags$h2(i18n("Edit data"), align = "center"),
  edit_data_ui(id = "id"),
  verbatimTextOutput("result")
)


server <- function(input, output, session) {

  edited_r <- edit_data_server(
    id = "id",
    data_r = reactive(demo_edit),
    add = TRUE,
    update = TRUE,
    delete = TRUE,
    download_csv = TRUE,
    download_excel = TRUE,
    file_name_export = "datas",
    # var_edit = c("name", "job", "credit_card_provider", "credit_card_security_code"),
    var_mandatory = c("name", "job")
  )

  output$result <- renderPrint({
    str(edited_r())
  })

}

if (interactive())
  shinyApp(ui, server)
}
