% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe_datas.R
\docType{data}
\name{crownradii}
\alias{crownradii}
\title{Tree crown radii}
\format{
Contains of variables, as follows:
\describe{
\item{spp}{Species code. Ro is Roble, Co is Coigue and Ol is Olivillo.}
\item{dbh}{Diameter at breast height, in cm.}
\item{htot}{Total height, in m.}
\item{r.n}{Crown radii towards the north, in m.}
\item{r.e}{Crown radii towards the east, in m.}
 \item{r.s}{Crown radii towards the south, in m.}
\item{r.w}{Crown radii towards the west, in m.}
\item{x.coord}{Cardinal position at the X-axis, in m.}
\item{y.coord}{Cardinal position at the Y-axis, in m.}
\item{crown.d}{Crown diameter, in m.}
 }
}
\source{
Data were provided by Dr Christian Salas-Eljatib (Santiago, Chile).
}
\usage{
data(crownradii)
}
\description{
Crown radii measurements in cardinal directions for sample trees at the Rucamanque experimental forest, near Temuco, Chile.
 Data were collected within a sample plot of 250m\eqn{^{2}}{^2}, located in a secondary forest stand
 dominated by Nothofagus obliqua.
}
\examples{
data(crownradii)    
head(crownradii) 
}
\references{
Salas C. 2001. Caracterizacion basica del relicto de biodiversidad Rucamanque [Basic characterization of the biodiversity remnant Rucamanque]. 
Bosque Nativo 29: 3–9.

Salas C, and Garcia O. 2006. Modelling height development of mature Nothofagus obliqua. 
Forest Ecology and Management 229 (1-3): 1–6.
}
\keyword{datasets}
