% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe_datas.R
\docType{data}
\name{eucaleaf}
\alias{eucaleaf}
\title{Leaf measurements for Eucalyptus nitens trees in Tasmania, Australia.}
\format{
Contains leaf-level variables, as follows:
\describe{
  \item{time}{Early or Late}
\item{tree}{an identificator for a given sample tree}
\item{shoot}{shoot description}
\item{l}{length of the leaf, in mm}
\item{w}{width of the leaf, in mm}
\item{la}{leaf area, in cm\eqn{^{2}}{^2}}
 }
}
\source{
Although the original source of the measurements is the Dissertation of Dr Candy (1999), 
 the data file used here was courtesy of Prof. Timothy Gregoire at
 Yale University (New Haven, CT, USA). Furthermore, these data were used by
 Gregoire and Salas (2009).
}
\usage{
data(eucaleaf)
}
\description{
The length, width, and area of Eucalyptus nitens leaves were measured.
}
\examples{
data(eucaleaf)    
head(eucaleaf) 
}
\references{
- Candy SG. 1999. Predictive models for integrated pest management of the
leaf beetle Chrysophtharta bimaculata in Eucalyptus nitens in Tasmania. Doctoral dissertation,
 University of Tasmania, Hobart, Australia.

- Gregoire TG, and Salas C. 2009. Ratio estimation with measurement
error in the auxiliary variate. Biometrics 65(2):590-598
}
\keyword{datasets}
