% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe_datas.R
\docType{data}
\name{treevolroble2}
\alias{treevolroble2}
\title{Variables alometricas a nivel de arbol para roble (Nothofagus obliqua) en el bosque de Rucamanque, cerca de Temuco, Chile.}
\format{
Las siguientes columnas son parte de la dataframe:
\describe{
  \item{arbol}{Numero del arbol.}
\item{especie}{Especie.}
\item{dap}{Diametro a la altura del pecho, en cm.}
\item{htot}{Altura total, en m.}
 \item{d6}{Diametro fustal a los 6 m, en cm.}
\item{vtot}{Volumen bruto total, en m\eqn{^{3}}{^3} with bark.}
 }
}
\source{
The data are provided courtesy of Dr Christian Salas-Eljatib (Chile).
}
\usage{
data(treevolroble2)
}
\description{
These are tree-level measurement data of sample trees in the Rucamanque experimental forest, 
 near Temuco, in the Araucania region in south-centralChile, measured in 1999.  The
data are the same as in the dataframe "treevolruca", but only having observations for the 
species roble (Nothofagus obliqua).
}
\examples{
data(treevolroble2)    
head(treevolroble2)
plot(vtot~dap, data=treevolroble2) 
}
\references{
- Salas C. 2002. Ajuste y validación de ecuaciones de volumen para un relicto
del bosque de Roble-Laurel-Lingue. Bosque 23(2): 81-92.  \url{https://eljatib.com/publication/2002-01-01_ajuste_y_validacion_/}
}
\keyword{datasets}
