% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe_datas.R
\docType{data}
\name{speciesList}
\alias{speciesList}
\title{Names and other information of plant species (mainly trees)}
\format{
A data frame with 63 observations on 31 variables
\describe{
\item{nesp}{Unique correlative specie number}
\item{spp.ci.name}{Species scientific name}
\item{spp.ci.abb}{Species scientific name abbreviation}
\item{common.name}{Species common name. No blank spaces,  no special characters}
\item{common.nameBlank}{Species common name. With blank spaces,  no special characters}
\item{esp}{Species code: code given by CEM Biometrics to identify species for different processing routines}
\item{common.nameLatex}{Species common name formatted for Latex}
\item{nTaxon}{Unique number of the taxon (i.e., species)}
\item{kingdom}{Taxonomic rank Kingdom. In this datase, all species belong to the Kingdom Plantae}
\item{division}{Taxonomic rank division or phylum within the Kingdom}
\item{class}{Taxonomic rank Class within the Kingdom}
\item{order}{Taxonomic rank Order within the Class}
\item{family}{Taxonomic rank Family within the Order}
\item{spp.ci.full}{Full scientific name including author}
\item{genus}{Taxonomic rank Genus within the Family}
\item{epithet}{Specific epithet}
\item{sppAuthor}{Species author}
\item{subSpp}{Subespecies: one of two or more populations of a species varying from one another by morphological characteristics}
\item{subSppAuthor}{Subespecies author}
\item{varSpp}{Species variety or varietas}
\item{varSppAuthor}{Variety author}
\item{formSpp}{Form or forma}
\item{formSppAuthor}{Form author}
\item{commonNamesList}{List of common names per species, separated by commas}
\item{synonyms}{Synonyms of the scientific name by which the species has been or is known}
\item{borCountries}{Border countries given the species distribution range}
\item{habit}{Habit. The general appearance, growth form, or architecture e.g., tree, shrub, grass}
\item{lifeCycle}{Life cycle}
\item{statusOri}{Status according to the species origin: Native or Endemic}
\item{regDist}{Distribution range of the species, within Chile administrative regions}
\item{elevRange}{Distribution range of the species, in terms of elevation. Meters above sea level}
\item{notes}{Notes}
}
}
\source{
Data provided from \url{https://investigacion.conaf.cl/repositorio/documento/ficha-repositorio.php?redo_id=1080946}
}
\usage{
data(speciesList)
}
\description{
This data set provides names (taxonomy), of plant species. Includes codes and name abbreviations used by the Biometrics group at the Forest Biometrics and Modelling Lab, Universidad de Chile, Santiago, Chile.
}
\references{
Proyecto 004/2016 Lista sistematica actualizada de la flora vascular nativa de Chile, origen y distribucion geografica. VII Concurso del Fondo de Investigacion del Bosque Nativo
}
\keyword{datasets}
