% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotrend.r
\name{plotrend}
\alias{plotrend}
\title{Function for building a scatterplot with a superposing
smoothed line}
\usage{
plotrend(
  x = x,
  y = y,
  col.dots = "black",
  linecol = "blue",
  xlab = NULL,
  ylab = NULL,
  pch.dots = 19,
  xlim = NA,
  ylim = NA,
  cex.dots = 1
)
}
\arguments{
\item{x}{A numeric vector representing the X-axis variable.}

\item{y}{A numeric vector representing the Y-axis variable (response).}

\item{col.dots}{A string specifying the dot colors. The default
value is "black".}

\item{linecol}{A string specifying the smooth line color. The default
is set to "blue".}

\item{xlab}{(optional) A string specifying X-axis label.}

\item{ylab}{(optional) A string specifying Y-axis label.}

\item{pch.dots}{A numeric factor altering the shape of the dots.}

\item{xlim}{(optional) A numeric vector having the minimum and maximum,
respectively for the X-axis variable.}

\item{ylim}{(optional) A numeric vector having the minimum and maximum,
respectively for the Y-axis variable.}

\item{cex.dots}{A numeric factor altering the size of the dots. The
default value is 0.7.}
}
\value{
The function returns the above described graph.
}
\description{
The function creates a scatterplot with a superposing smoothed
line as a way to reveal any potential pattern between the
variables.
}
\details{
Notice that the smoothed-line is derived from a rather
standard algorithm (i.e., loess), implemented in the funcion
\code{smoothfit}, thus it is only an approximation.
}
\examples{
df <- datana::maple
head(df)
m1<-lm(leaf~dbh,data=df)
# Example 1, a residual plot
plotrend(x=df$dbh,y=residuals(m1))
abline(h=0)
}
\references{
\itemize{
\item Salas-Eljatib C. 2021. Análisis de datos con el programa
estadístico R:
una introducción aplicada.
Ediciones Universidad Mayor. Santiago, Chile. 170 p.
\url{https://eljatib.com}
}

\itemize{
\item Salas C, Stage AR, and Robinson AP. 2008. Modeling effects of
overstory density and competing
vegetation on tree height growth. Forest Science 54(1):107-122.
\doi{10.1093/forestscience/54.1.107}
}
}
\author{
Christian Salas-Eljatib
}
