% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/D1Object.R
\name{canRead,D1Object-method}
\alias{canRead,D1Object-method}
\title{Test whether the provided subject can read an object.}
\usage{
\S4method{canRead}{D1Object}(x, subject)
}
\arguments{
\item{x}{D1Object}

\item{subject}{: the subject name of the person/system to check for read permissions}
}
\value{
logical TRUE if the subject has read permission, or FALSE otherwise
}
\description{
Using the AccessPolicy, tests whether the subject has read permission
for the object.  This method is meant work prior to submission to a repository, 
and will show the permissions that would be enforced by the repository on submission.
Currently it only uses the AccessPolicy to determine who can read (and not the rightsHolder field,
which always can read an object).  If an object has been granted read access by the
special "public" subject, then all subjects have read access.
}
\details{
The subject name used in both the AccessPolicy and in the \code{'subject'}
argument to this method is a string value, but is generally formatted as an X.509
name formatted according to RFC 2253.
}
