% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SystemMetadata.R, R/DataObject.R
\docType{methods}
\name{addAccessRule}
\alias{addAccessRule}
\alias{addAccessRule,DataObject-method}
\alias{addAccessRule,SystemMetadata-method}
\title{Add access rules to the specified object.}
\usage{
addAccessRule(x, ...)

\S4method{addAccessRule}{SystemMetadata}(x, y, ...)

\S4method{addAccessRule}{DataObject}(x, y, ...)
}
\arguments{
\item{x}{The object instance to which to add the rules}

\item{...}{Additional arguments
\itemize{
  \item{permission The permission to be applied to subject if x is character (read, write, changePermission)}
}}

\item{y}{The subject of the rule to be added, or a data frame of subject/permission tuples}
}
\value{
the SystemMetadata object with the updated access policy.

the DataObject with the updated access policy
}
\description{
Add one or more access rules to the access policy of the specified object.
}
\examples{
# Parameter "y" can be character string containing the subject of the access rule:
sysmeta <- new("SystemMetadata")
sysmeta <- addAccessRule(sysmeta, "uid=smith,ou=Account,dc=example,dc=com", "write")
accessRules <- data.frame(subject=c("uid=smith,ou=Account,dc=example,dc=com", 
  "uid=slaughter,o=unaffiliated,dc=example,dc=org"), permission=c("write", "changePermission"))
sysmeta <- addAccessRule(sysmeta, accessRules)
# Alternatively, parameter "y" can be a data.frame containing one or more access rules:
sysmeta <- addAccessRule(sysmeta, "uid=smith,ou=Account,dc=example,dc=com", "write")
accessRules <- data.frame(subject=c("uid=smith,ou=Account,dc=example,dc=com", 
  "uid=slaughter,o=unaffiliated,dc=example,dc=org"), permission=c("write", "changePermission"))
sysmeta <- addAccessRule(sysmeta, accessRules)
data <- charToRaw("1,2,3\\n4,5,6\\n")
obj <- new("DataObject", id="1234", data=data, format="text/csv")
obj <- addAccessRule(obj, "uid=smith,ou=Account,dc=example,dc=com", "write")
}
\seealso{
\code{\link{SystemMetadata-class}}
}

