% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataPackage.R
\docType{methods}
\name{containsId}
\alias{containsId}
\alias{containsId,DataPackage-method}
\title{Returns true if the specified object is a member of the package}
\usage{
containsId(x, ...)

\S4method{containsId}{DataPackage}(x, identifier)
}
\arguments{
\item{x}{A DataPackage object}

\item{...}{(Not yet used)}

\item{identifier}{The DataObject identifier to check for inclusion in the DataPackage}
}
\value{
A logical - a value of TRUE indicates that the DataObject is in the DataPackage
}
\description{
Returns true if the specified object is a member of the package
}
\examples{
dp <- new("DataPackage")
data <- charToRaw("1,2,3\\n4,5,6")
id <- "myNewId"
do <- new("DataObject", id=id, dataobj=data, format="text/csv", user="jsmith")
dp <- addData(dp, do)
isInPackage <- containsId(dp, identifier="myNewId")
}
\seealso{
\code{\link{DataPackage-class}}
}

