% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResourceMap.R
\docType{methods}
\name{createFromTriples}
\alias{createFromTriples}
\alias{createFromTriples,ResourceMap-method}
\title{Populate a ResourceMap with RDF relationships from data.frame.}
\usage{
createFromTriples(x, ...)

\S4method{createFromTriples}{ResourceMap}(x, relations, identifiers,
  resolveURI = as.character(NA), ...)
}
\arguments{
\item{x}{a ResourceMap}

\item{...}{(Additional parameters)}

\item{relations}{A data.frame to read relationships from}

\item{identifiers}{A list of the identifiers of data objects cotained in the associated data package}

\item{resolveURI}{A character string containing a URI to prepend to datapackage identifiers.}
}
\description{
RDF relationships are added to a ResourceMap object from a data.frame that
contains RDF triples. For example, relationships can be exported from a DataPackage via
\code{\link{getRelationships}}. The resulting data.frame is then read by \code{createFromTriples}
to create the ResourceMap.
}
\details{
The \code{identifiers} parameter contains the identifiers of all data objects in the DataPackage.
For each data objects, additional relationships will be added that are required by the OAI-ORE specification,
for example a Dublin Core identifier statement is added. The resolveURI string value is prepended to 
DataPackage member identifiers in the resulting resource map. If no resolveURI value
is specified, then 'https://cn.dataone.org/cn/v1/resolve' is used.
}
\examples{
library(datapack)
dp <- new("DataPackage")
data <- charToRaw("1,2,3\\n4,5,6")
do1 <- new("DataObject", id="id1", data, format="text/csv")
do2 <- new("DataObject", id="id2", data, format="text/csv")
dp <- addData(dp, do1)
dp <- addData(dp, do2)
dp <- insertRelationship(dp, subjectID="id1", objectIDs="id2", 
  predicate="http://www.w3.org/ns/prov#wasDerivedFrom")
relations <- getRelationships(dp)
resMapId <- sprintf("\%s\%s", "resourceMap_", uuid::UUIDgenerate())  
resMap <- new("ResourceMap", id=resMapId)
resMap <- createFromTriples(resMap, relations, getIdentifiers(dp)) 
}
\seealso{
\code{\link{ResourceMap-class}}
}

