% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataPackage.R
\docType{methods}
\name{getValue}
\alias{getValue}
\alias{getValue,DataPackage-method}
\title{Get values for selected DataPackage members.}
\usage{
getValue(x, ...)

\S4method{getValue}{DataPackage}(x, name, identifiers = as.character(NA))
}
\arguments{
\item{x}{A DataPackage instance}

\item{...}{(Not yet used)}

\item{name}{A name of a DataObject slot.}

\item{identifiers}{A list of DataPackage member identifiers}
}
\value{
A list of values for matching slot names and included identifiers.
}
\description{
Given a slot name and set of package member identifiers, return slot values.
}
\details{
If the parameter \code{identifiers} is provided, then only the DataPackage
members that have identifiers in the provided list will have there values fetched.
If this parameter is not provided, then the values for all DataPackage members are returned.
}
\examples{
dp <- new("DataPackage")
data <- charToRaw("1,2,3\\n4,5,6")
do <- new("DataObject", id="myNewId", dataobj=data, format="text/csv", user="jsmith")
dp <- addMember(dp, do)
data <- charToRaw("7,8.9\\n4,10,11")
do <- new("DataObject", id="myNewId2", dataobj=data, format="text/csv", user="jsmith")
dp <- addMember(dp, do)
formats <- getValue(dp, name="sysmeta@formatId")
}
\seealso{
\code{\link{DataPackage-class}}
}
