% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/con_limit_deviations.R
\name{con_detection_limits}
\alias{con_detection_limits}
\title{con_detection_limits}
\usage{
con_detection_limits(
  resp_vars = NULL,
  label_col,
  study_data,
  meta_data,
  limits = c("DETECTION_LIMITS", "HARD_LIMITS", "SOFT_LIMITS")
)
}
\arguments{
\item{resp_vars}{\link{variable list} the name of the measurement variables}

\item{label_col}{\link{variable attribute} the name of the column in the metadata
with labels of variables}

\item{study_data}{\link{data.frame} the data frame that contains the measurements}

\item{meta_data}{\link{data.frame} the data frame that contains metadata
attributes of study data}

\item{limits}{\link{enum} HARD_LIMITS | SOFT_LIMITS | DETECTION_LIMITS. what
limits from metadata to check for}
}
\value{
a list with:
\itemize{
\item \code{FlaggedStudyData} \link{data.frame} related to the study data by a 1:1
relationship, i.e. for each observation is
checked whether the value is below or above
the limits.
\item \code{SummaryTable} \link{data.frame} summarizes limit deviations for each
variable.
\item \code{SummaryPlotList} \link{list} of \link{ggplot}s The plots for each variable are
either a histogram (continuous) or a
barplot (discrete).
\item \code{ModifiedStudyData} \link{data.frame}  If the function identifies limit
deviations, the respective values are
removed in \code{ModifiedStudyData.}
\item \code{ReportSummaryTable}: heatmap-like data frame about limit violations
}
}
\description{
\subsection{APPROACH}{

Inadmissible numerical values can be of type integer or float. This
implementation requires the definition of intervals in the metadata to
examine the admissibility of numerical study data.

This helps identify inadmissible measurements according to
hard limits (for multiple variables).
}
}
\details{
\subsection{ALGORITHM OF THIS IMPLEMENTATION:}{
\itemize{
\item Remove missing codes from the study data (if defined in the metadata)
\item Interpretation of variable specific intervals as supplied in the metadata.
\item Identification of measurements outside defined limits. Therefore two
output data frames are generated:
\itemize{
\item on the level of observation to flag each deviation, and
\item a summary table for each variable.
}
\item A list of plots is generated for each variable examined for limit
deviations. The histogram-like plots indicate respective limits as well
as deviations.
\item Values exceeding limits are removed in a data frame of modified study data
}

For \link{con_detection_limits}, The default for the limits argument differs and
is here "DETECTION_LIMITS"
}
}
\examples{
load(system.file("extdata", "study_data.RData", package = "dataquieR"))
load(system.file("extdata", "meta_data.RData", package = "dataquieR"))

# make things a bit more complicated for the function, giving datetimes
# as numeric
study_data[,
  vapply(study_data, inherits, "POSIXct", FUN.VALUE = logical(1))] <-
  lapply(study_data[, vapply(study_data, inherits, "POSIXct",
  FUN.VALUE = logical(1))], as.numeric)

MyValueLimits <- con_limit_deviations(
  resp_vars = NULL,
  label_col = "LABEL",
  study_data = study_data,
  meta_data = meta_data,
  limits = "HARD_LIMITS"
)

names(MyValueLimits$SummaryPlotList)

MyValueLimits <- con_limit_deviations(
  resp_vars = c("QUEST_DT_0"),
  label_col = "LABEL",
  study_data = study_data,
  meta_data = meta_data,
  limits = "HARD_LIMITS"
)

MyValueLimits$SummaryPlotList$QUEST_DT_0
}
\seealso{
\itemize{
\item \link{con_limit_deviations}
\item \href{https://dataquality.ship-med.uni-greifswald.de/VIN_con_impl_limit_deviations.html}{Online Documentation}
}
}
