% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/C3FURV.R
\name{subdaily_repetition}
\alias{subdaily_repetition}
\title{Sub-daily repetition test}
\usage{
subdaily_repetition(subdailydata = file.choose(), meta = NULL, outpath, n = 6)
}
\arguments{
\item{subdailydata}{A character string giving the path of the input file,
or a 7-column matrix with following columns: variable code, year, month,
day, hour, minute, value.}

\item{meta}{A character vector with 6 elements: station ID, latitude, longitude,
altitude, variable code, units. If \code{subdailydata} is a path, \code{meta} is
ignored.}

\item{outpath}{Character string giving the path for the QC results.}

\item{n}{Number of minimum equal consecutive values required for a flag. The
default is 6.}
}
\description{
Report occurrences of equal consecutive values in subdaily data.
}
\details{
The input file must follow the Copernicus Station Exchange Format (SEF).

Zeroes are automatically excluded in bounded variables such as precipitation.
}
\examples{
subdaily_repetition(Rosario$ta, Meta$ta[which(Meta$ta$id=="Rosario"),], 
                    outpath = tempdir(), n = 3)

}
\author{
Alba Gilabert, Yuri Brugnara
}
