% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output.R
\name{write_flags}
\alias{write_flags}
\title{Add quality flags to a data file in Station Exchange Format version 1.0.0}
\usage{
write_flags(infile, qcfile, outpath, note = "")
}
\arguments{
\item{infile}{Character string giving the path of the SEF file.}

\item{qcfile}{Character string giving the path of the file with
the quality flags as produced with the QC tests. 
This file must have 6 (8) tab-separated columns
for daily (sub-daily) data: variable code, year, month, day, (hour),
(minute), value, semicolon(';')-separated failed tests.}

\item{outpath}{Character string giving the output path.}

\item{note}{Character string to be added to the end of the name of the
input file to form the output filename. 
It will be separated from the rest of the name by an underscore.
Blanks will be also replaced by underscores.
If not specified, input and output filenames will be identical.}
}
\description{
Add quality flags to a data file in Station Exchange Format version 1.0.0
}
\note{
The data will be converted to the standard units adopted by the qc.
An exception is made for cloud cover (oktas will not be converted).
}
\author{
Yuri Brugnara
}
