% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModelRecommendations.R
\name{GetModelRecommendation}
\alias{GetModelRecommendation}
\title{Retrieve a model recommendedation from DataRobot for your project.}
\usage{
GetModelRecommendation(project, type = RecommendedModelType$FastAccurate)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{type}{character. The type of recommendation to retrieve. See
\code{RecommendedModelType} for available options. Defaults to
\code{RecommendedModelType$FastAccurate}.}
}
\value{
A list containing information about the recommended model:
\itemize{
  \item modelId character. The model ID of the recommended model.
  \item projectId character. The project ID of the project the recommendations were made for.
  \item recommendationType character. The type of recommendation being made.
}
}
\description{
Retrieve a model recommendedation from DataRobot for your project.
}
\examples{
\dontrun{
  projectId <- "5984b4d7100d2b31c1166529"
  GetModelRecommendation(projectId)
}
}
