% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Models.R
\name{GetModelFromJobId}
\alias{GetModelFromJobId}
\title{Retrieve a new or updated model defined by modelJobId}
\usage{
GetModelFromJobId(project, modelJobId, maxWait = 600)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{modelJobId}{The integer returned by either RequestNewModel
or RequestSampleSizeUpdate.}

\item{maxWait}{Integer, The maximum time (in seconds) to wait for the model job to complete}
}
\value{
An S3 object of class 'dataRobotModel' summarizing all
available information about the model.
}
\description{
The functions RequestNewModel and RequestSampleSizeUpdate
initiate the creation of new models in a DataRobot project.
Both functions submit requests to the DataRobot modeling
engine and return an integer-valued modelJobId.  The
GetModelFromJobId function polls the modeling engine until
the model has been built or a specified time limit is exceeded,
returning an S3 object of class 'dataRobotModel' when the model
is available.
}
\details{
Motivation for this function is the fact that some models -
e.g., very complex machine learning models fit to large datasets -
may take a long time to complete.  Splitting the model creation
request from model retrieval in these cases allows the user to
perform other interactive R session tasks between the time the
model creation/update request is made and the time the final
model is available.
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  initialJobs <- ListModelJobs(project)
  job <- initialJobs[[1]]
  modelJobId <- job$modelJobId
  GetModelJobFromJobId(projectId, modelJobId)
}
}
