% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SetupProject.R
\name{SetupProjectFromHDFS}
\alias{SetupProjectFromHDFS}
\title{Function to set up a new DataRobot project using datasource on a WebHDFS server}
\usage{
SetupProjectFromHDFS(url, port = NULL, projectName = NULL,
  maxWait = 60 * 60)
}
\arguments{
\item{url}{character. The location of the WebHDFS file,
both server and full path. Per the DataRobot specification, must begin with hdfs://}

\item{port}{integer. Optional. The port to use. If not specified, will default to the server
default (50070).}

\item{projectName}{character. Optional. String specifying a project name.}

\item{maxWait}{integer. The maximum time to wait for each of two steps: (1) The initial
project creation request, and (2) data processing that occurs after receiving the response
to this initial request.}
}
\value{
This function returns a list with the following four components:
\describe{
  \item{projectName}{The name assigned to the DataRobot project}
  \item{projectId}{The unique alphanumeric project identifier for this DataRobot project}
  \item{fileName}{The name of the CSV modeling file uploaded for this project}
  \item{created}{Character string containing the time and date of project creation}
}
}
\description{
This function returns the projectName specified in the
calling sequence, the unique alphanumeric identifier projectId for the new
project, the name of the modeling dataset uploaded to create this project,
and the project creation time and date.
}
\examples{
\dontrun{
  SetupProjectFromHDFS(url = 'hdfs://path/to/data',
                       port = 12345,
                       projectName = 'dataProject')
}
}
