% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Partitions.R
\name{CreateRandomPartition}
\alias{CreateRandomPartition}
\title{Create a random sampling-based S3 object of class partition for the SetTarget function}
\usage{
CreateRandomPartition(
  validationType,
  holdoutPct,
  reps = NULL,
  validationPct = NULL
)
}
\arguments{
\item{validationType}{character. String specifying the type of partition
generated, either "TVH" or "CV".}

\item{holdoutPct}{integer. The percentage of data to be used as the holdout subset.}

\item{reps}{integer. The number of cross-validation folds to generate; only applicable
when validationType = "CV".}

\item{validationPct}{integer. The percentage of data to be used as the validation subset.}
}
\value{
An S3 object of class partition including the parameters
  required by SetTarget to generate a random partitioning of
  the modeling dataset.
}
\description{
Random partitioning is supported for either Training/Validation/Holdout
("TVH") or cross-validation ("CV") splits. In either case, the holdout
percentage (holdoutPct) must be specified; for the "CV" method, the
number of cross-validation folds (reps) must also be specified, while
for the "TVH" method, the validation subset percentage (validationPct)
must be specified.
}
\details{
This function is one of several convenience functions provided to simplify the task
of starting modeling projects with custom partitioning options. The other
functions are \code{CreateGroupPartition}, \code{CreateStratifiedPartition}, and
\code{CreateUserPartition}.
}
\examples{
CreateRandomPartition(validationType = "CV", holdoutPct = 20, reps = 5)
}
\seealso{
\code{\link{CreateStratifiedPartition}}, \code{\link{CreateGroupPartition}},
  \code{\link{CreateUserPartition}}.
}
