% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Featurelists.R
\name{CreateFeaturelist}
\alias{CreateFeaturelist}
\title{Create a new featurelist in a DataRobot project}
\usage{
CreateFeaturelist(project, listName, featureNames)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{listName}{character. String identifying the new featurelist
to be created.}

\item{featureNames}{character. Vector listing the names of the
variables to be included in the featurelist.}
}
\value{
A list with the following four elements describing
the featurelist created:
\describe{
  \item{featurelistId}{Character string giving the unique
  alphanumeric identifier for the new featurelist.}
  \item{projectId}{Character string giving the projectId
  identifying the project to which the featurelist was added.}
  \item{features}{Character vector with the names of the
  variables included in the new featurelist.}
  \item{name}{Character string giving the name of the new
  featurelist.}
}
}
\description{
This function allows the user to create a new featurelist
in a project by specifying its name and a list of variables
to be included
}
\details{
DataRobot featurelists define the variables from the modeling
dataset used in fitting each project model. Some functions
(SetTarget, StartNewAutopilot) optionally accept a featurelist
(and use a default featurelist if none is specified).
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  CreateFeaturelist(projectId, "myFeaturelist", c("feature1", "feature2", "otherFeature"))
}
}
