% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var_concept.R
\name{var_concept}
\alias{var_concept}
\alias{var_concept<-}
\alias{var_concept<-.default}
\title{Get / set a concept definition for a vector or a dataset}
\usage{
var_concept(x, ...)

var_concept(x) <- value

\method{var_concept}{default}(x) <- value
}
\arguments{
\item{x}{A vector to which the concept URI will be assigned.}

\item{...}{Further parameters for inheritance, not in use.}

\item{value}{A character string with a concept URI or NULL to remove the concept.}
}
\value{
The (linked) concept of the meaning of the data contained by a
vector constructed with \code{\link{defined}}.

The modified vector with updated \code{concept} metadata.
}
\description{
Assigns a concept URI to a vector created with \code{defined()}. This
method updates the \code{concept} attribute and validates that the input is a single
character string or NULL.
}
\details{
\code{get_variable_concepts()} is identical to \code{var_concept()}.
}
\examples{
small_country_dataset <- dataset_df(
  country_name = defined(c("Andorra", "Lichtenstein"), label = "Country"),
  gdp = defined(c(3897, 7365),
    label = "Gross Domestic Product",
    unit = "million dollars"
  )
)
var_concept(small_country_dataset$country_name) <- "http://data.europa.eu/bna/c_6c2bb82d"
var_concept(small_country_dataset$country_name)
# To remove a concept definition of variable
var_concept(small_country_dataset$country_name) <- NULL
x <- defined(c(1, 2, 3), label = "Example Variable")
var_concept(x) <- "http://example.org/concept/XYZ"
var_concept(x)
}
