% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_metadata.R
\name{generate_metadata}
\alias{generate_metadata}
\title{Generate metadata}
\usage{
generate_metadata(
  df,
  destination,
  key_cols = NA,
  diffed = TRUE,
  backup_count = 0L
)
}
\arguments{
\item{df}{a data frame to create a dv from}

\item{destination}{a local directory path or an arrow SubTreeFileSystem}

\item{key_cols}{a character vector of column names that constitute a unique key}

\item{diffed}{should we store diffs between each dv version?}

\item{backup_count}{how many backups should we store?}
}
\value{
a list
}
\description{
Generate a conformant metadata structure for a versioned dataset
}
\examples{
temp_dir <- tempfile()
dir.create(temp_dir, recursive = TRUE)
df <- data.frame(a = 1:5, b = letters[1:5])

generate_metadata(df, temp_dir)

unlink(temp_dir)

}
