% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_nan_inf.R
\name{replace_nan_inf}
\alias{replace_nan_inf}
\title{Convert infinite or \code{NaN} values into \code{NA}}
\usage{
replace_nan_inf(x, ...)
}
\arguments{
\item{x}{A vector or a dataframe}

\item{...}{Currently not used.}
}
\value{
Data with \code{Inf}, \code{-Inf}, and \code{NaN} converted to \code{NA}.
}
\description{
Replaces all infinite (\code{Inf} and \code{-Inf}) or \code{NaN} values with \code{NA}.
}
\examples{
# a vector
x <- c(1, 2, NA, 3, NaN, 4, NA, 5, Inf, -Inf, 6, 7)
replace_nan_inf(x)

# a data frame
df <- data.frame(
  x = c(1, NA, 5, Inf, 2, NA),
  y = c(3, NaN, 4, -Inf, 6, 7),
  stringsAsFactors = FALSE
)
replace_nan_inf(df)
}
