% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deter.R
\encoding{UTF-8}
\name{load_deter}
\alias{load_deter}
\title{DETER - Forest Degradation in the Brazilian Amazon}
\usage{
load_deter(dataset = NULL, raw_data, language = "eng")
}
\arguments{
\item{dataset}{A dataset name ("deter_amz", "deter_cerrado") with information about both Amazon and Cerrado}

\item{raw_data}{A \code{boolean} setting the return of raw (\code{TRUE}) or processed (\code{FALSE}) data.}

\item{language}{A \code{string} that indicates in which language the data will be returned. Currently, only Portuguese ("pt") and English ("eng") are supported. Defaults to "eng".}
}
\value{
A \code{tibble} with the selected data.
}
\description{
Loads information on change in forest cover in the Amazon. See \url{http://www.obt.inpe.br/OBT/assuntos/programas/amazonia/deter/deter}
}
\examples{
\dontrun{
# Download raw data (raw_data = TRUE) from Amazonia (dataset = "deter_amz")
deter_amz <- load_deter(
  dataset = "deter_amz",
  raw_data = TRUE
)

# Download treated data (raw_data = FALSE) from Cerrado (dataset = "deter_cerrado")
# in portuguese (language = 'pt')
deter_cer <- load_deter(
  dataset = "deter_cerrado",
  raw_data = FALSE,
  language = "pt"
)
}

}
